<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns="http://www.w3.org/1999/xhtml">
<xsl:output method="xml" encoding="utf-8"
            doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

<xsl:attribute-set name="bmvbs">
   
   <xsl:attribute name="title">Bewertung nach den Fraunhofer IBP Vorschlägen</xsl:attribute>
   
</xsl:attribute-set>

<xsl:attribute-set name="ibp">
   <xsl:attribute name="src">./bilder/logo_ibp.gif</xsl:attribute>
   <xsl:attribute name="alt">Logo Fraunhofer IBP</xsl:attribute>
   <xsl:attribute name="title">Fraunhofer Institut für Bauphysik</xsl:attribute>
   <xsl:attribute name="class">ibplogo</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="raum">
   <xsl:attribute name="src">./bilder/Raum.jpg</xsl:attribute>
   <xsl:attribute name="alt">Grafik Position vom Raum</xsl:attribute>
   <xsl:attribute name="title">Info-Grafik zur Position vom Raum</xsl:attribute>
   <xsl:attribute name="width">100%</xsl:attribute>
   <xsl:attribute name="height">100%</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="dokument">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<title><xsl:value-of select="/dokument/titel" /></title>
<link rel="stylesheet" media="screen" type="text/css" href="./css/formate.css" />
<link rel="stylesheet" media="screen" type="text/css" href="./css/formate_css3_.css" />
<link rel="stylesheet" media="print" type="text/css" href="./css/print.css" />
</head>
<body>

<div id="mitte" class="rund">

<div id="kopf">
<div class="spalten">
   <div class="spalte1">
      <xsl:element name="img" use-attribute-sets="bmvbs" />
   </div>
   <div class="spalte2 bnbtitel">
<span class="gross fett">Bewertungssystem Nachhaltiges Bauen (BNB)<br />
Neubau Büro- und Verwaltungsgebäude</span>
   </div>
   <div class="spalte3">
      <xsl:if test="/dokument/kopf/version">
         <xsl:value-of select="/dokument/kopf/version" />
      </xsl:if>
   </div>
</div>

<div class="spalten dunkel">
   <div class="spalte1 abstand1">
<span class="klein">Kriterium:</span>
   </div>
   <div class="spalte2l abstand2 fett">
Thermischer Komfort: Entwurf
   </div>
</div>
<div class="spalten hell">
   <div class="spalte1 abstand1">

   </div>
   <div class="spalte2l abstand2 hell fett">
Bewertungen anhand BNB Komfort Tool: Entwurf
   </div>
</div>
<div class="spalten dunkel">
   <div class="spalte1 abstand1">
<span class="klein">Zone Name:</span>
   </div>
   <div class="spalte2l abstand2">

   </div>
</div>

</div> <!-- Ende Kopf -->

<xsl:for-each select="kapitel">
   <xsl:call-template name="Kapitel" />
</xsl:for-each>

<div id="fuss">
   <xsl:element name="img" use-attribute-sets="ibp" />
<span class="klein fett">BNB Komfort Tool</span>
</div> <!-- Ende Fuß -->

</div> <!-- Ende Mitte -->

</body>
</html>
</xsl:template>

<xsl:template name="Kapitel">
<xsl:variable name="umbruch" select="position()" />

<xsl:for-each select=".">
<h1><xsl:if test="$umbruch > 1">
       <xsl:attribute name="class">umbruch</xsl:attribute>
    </xsl:if>
    <xsl:value-of select="concat(./@nr,'. ',./@titel)" /></h1>

<xsl:for-each select="abschnitt">
   <xsl:call-template name="Tabelle" />

   <xsl:if test="./@nr = 3.1">
   <div class="grundriss">
      <xsl:element name="img" use-attribute-sets="raum" />
   </div>
   </xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:template>

<xsl:template name="Tabelle">
<h2><xsl:value-of select="concat(./@nr,' ',./@titel)" /></h2>

<table>
<xsl:if test="starts-with(./@titel,'Points')">
   <xsl:attribute name="class">punkte</xsl:attribute>
</xsl:if>
<xsl:for-each select="zeile">
   <tr>
   <xsl:choose>
      <xsl:when test="./@nr = 0">
         <xsl:if test="./@titel">
      <th>
            <xsl:value-of select="./@titel" /></th>
         </xsl:if>
         <xsl:for-each select="wert">
      <th>
            <xsl:if test="./@sp">
               <xsl:attribute name="colspan"><xsl:value-of select="./@sp" /></xsl:attribute>
            </xsl:if>
            <xsl:value-of select="." />
      </th>
         </xsl:for-each>   
      </xsl:when>
      <xsl:otherwise>
         <xsl:if test="./@titel">
      <th>
            <xsl:value-of select="./@titel" /></th>
         </xsl:if>
         <xsl:for-each select="wert">
      <td><xsl:value-of select="." /></td>
         </xsl:for-each>   
      </xsl:otherwise>
   </xsl:choose>
   </tr>
</xsl:for-each>   
</table>
</xsl:template>

<xsl:template name="AnhangSommer">
<ul class="anhang">
   <li>Anhang 1<br />
       : Randbedingungen</li>
   <li>Anhang 2 im Fall maschineller Kühlung<br />
       : Auslegungsnachweis</li>
   <li>Anhang 3 im Fall maschineller Lüftung<br />
       : Produktionsblatt (RLT)</li>
   <li>Anhang 4 im Fall mit Flächenkühlung<br />
       : Produktionsblatt (Flächenkühlung)</li>
   <li>Anhang 5 im Fall bei mehreren Räumen<br />
       : Operative Temperatur Bewertung für mehrere Zonen</li>
</ul>
</xsl:template>

<xsl:template name="AnhangWinter">
<ul class="anhang">
   <li>Anhang 1<br />
       : Randbedingungen</li>
   <li>Anhang 3 im Fall maschineller Lüftung<br />
       : Produktionsblatt (RLT)</li>
   <li>Anhang 4 im Fall mit Flächenheizung<br />
       : Produktionsblatt (Flächenheizung)</li>
   <li>Anhang 5 im Fall bei mehreren Räumen<br />
       : Operative Temperatur Bewertung für mehrere Zonen</li>
</ul>
</xsl:template>

</xsl:stylesheet>